/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.sub.RenderingConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTotemDollConfig {
    public static final Codec<MyTotemDollConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("mod_enabled").forGetter(MyTotemDollConfig::isModEnabled), (App)Codec.BOOL.fieldOf("debug_log_enabled").forGetter(MyTotemDollConfig::isDebugLogEnabled), (App)RenderingConfig.CODEC.fieldOf("rendering_config").forGetter(MyTotemDollConfig::getRenderingConfig)).apply((Applicative)instance, MyTotemDollConfig::new));
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("my-totem-doll.json5").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"My Totem Doll/Config");
    private boolean modEnabled;
    private boolean debugLogEnabled;
    private RenderingConfig renderingConfig;

    public MyTotemDollConfig() {
        this.modEnabled = true;
        this.debugLogEnabled = false;
        this.renderingConfig = RenderingConfig.getDefault();
    }

    public MyTotemDollConfig(boolean modEnabled, boolean debugLogEnabled, RenderingConfig renderingConfig) {
        this.modEnabled = modEnabled;
        this.debugLogEnabled = debugLogEnabled;
        this.renderingConfig = renderingConfig;
    }

    public static MyTotemDollConfig getInstance() {
        return MyTotemDollConfig.read();
    }

    @NotNull
    private static MyTotemDollConfig create() {
        MyTotemDollConfig config = new MyTotemDollConfig();
        try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
            String json = GSON.toJson((JsonElement)CODEC.encode((Object)config, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            writer.write(json);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create config", (Throwable)e);
        }
        return config;
    }

    private static MyTotemDollConfig read() {
        MyTotemDollConfig myTotemDollConfig;
        if (!CONFIG_FILE.exists()) {
            return MyTotemDollConfig.create();
        }
        FileReader reader = new FileReader(CONFIG_FILE, StandardCharsets.UTF_8);
        try {
            myTotemDollConfig = (MyTotemDollConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))).getFirst();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Failed to read config", (Throwable)e);
                return MyTotemDollConfig.create();
            }
        }
        reader.close();
        return myTotemDollConfig;
    }

    public void save() {
        MyTotemDollClient.setConfig(this);
        CompletableFuture.runAsync(() -> {
            try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
                String json = GSON.toJson((JsonElement)CODEC.encode((Object)this, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                writer.write(json);
            }
            catch (Exception e) {
                LOGGER.error("Failed to save config", (Throwable)e);
            }
        });
    }

    public boolean isModEnabled() {
        return this.modEnabled;
    }

    public boolean isDebugLogEnabled() {
        return this.debugLogEnabled;
    }

    public RenderingConfig getRenderingConfig() {
        return this.renderingConfig;
    }

    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    public void setDebugLogEnabled(boolean debugLogEnabled) {
        this.debugLogEnabled = debugLogEnabled;
    }

    public void setRenderingConfig(RenderingConfig renderingConfig) {
        this.renderingConfig = renderingConfig;
    }
}

